<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loan Application - Section 1</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }

        form {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            box-sizing: border-box;
        }

        label {
            display: block;
            margin-bottom: 8px;
        }

        input {
            width: 100%;
            padding: 8px;
            margin-bottom: 16px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        button {
            background-color: #4caf50;
            color: #fff;
            padding: 10px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
            box-sizing: border-box;
        }

        button:hover {
            background-color: #45a049;
        }

        @media only screen and (max-width: 600px) {
            form {
                max-width: 100%;
            }
        }
    </style>
</head>
<body>

<form action="form.php" method="post" enctype="multipart/form-data">
    <h2 style="text-align: center;">Loan Application - Section 1</h2>

    <label for="firstName">First Name:</label>
    <input type="text" name="firstName" required>

    <label for="lastName">Last Name:</label>
    <input type="text" name="lastName" required>

    <label for="streetAddress">Street Address:</label>
    <input type="text" name="streetAddress" required>

    <label for="zip">Zip:</label>
    <input type="text" name="zip" required>

    <label for="city">City:</label>
    <input type="text" name="city" required>

    <label for="state">State:</label>
    <input type="text" name="state" required>

    <label for="gender">Gender:</label>
    <select name="gender" required>
        <option value="male">Male</option>
        <option value="female">Female</option>
        <option value="other">Other</option>
    </select>

    <label for="age">What Is Your Age:</label>
    <input type="number" name="age" required>

    <label for="employmentStatus">Employment Status:</label>
    <select name="employmentStatus" required>
        <option value="employed">Employed</option>
        <option value="unemployed">Unemployed</option>
        <option value="selfEmployed">Self-Employed</option>
        <option value="student">Student</option>
    </select>

    <label for="phoneNumber">Phone Number:</label>
    <input type="tel" name="phoneNumber" required>

    <button type="button" onclick="nextSection()">Next</button>
</form>

<script>
    function nextSection() {
        // You can add logic to validate inputs if needed
        window.location.href = "sec2.php"; // Replace "section2.php" with the file for the next section
    }
</script>

</body>
</html>
