<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loan Application - Section 2</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }

        form {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            box-sizing: border-box;
        }

        label {
            display: block;
            margin-bottom: 8px;
        }

        input, select {
            width: 100%;
            padding: 8px;
            margin-bottom: 16px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        textarea {
            width: 100%;
            padding: 8px;
            margin-bottom: 16px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
            resize: vertical;
        }

        button {
            background-color: #4caf50;
            color: #fff;
            padding: 10px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
            box-sizing: border-box;
        }

        button:hover {
            background-color: #45a049;
        }

        @media only screen and (max-width: 600px) {
            form {
                max-width: 100%;
            }
        }
    </style>
</head>
<body>

<form action="form.php" method="post" enctype="multipart/form-data">
    <h2 style="text-align: center;">Loan Application - Section 2</h2>

    <label for="fundingType">Choose which type of funding you are interested in:</label>
    <select name="fundingType" required>
        <option value="personalLoan">Personal Loan</option>
        <option value="businessLoan">Business Loan</option>
        <option value="homeLoan">Home Loan</option>
    </select>

    <label for="loanAmount">How Much Money Are You Looking For?:</label>
    <input type="number" name="loanAmount" required>

    <label for="useOfMoney">Briefly Describe How You Will Use The Money:</label>
    <textarea name="useOfMoney" rows="4" required></textarea>

    <label for="emailAddress">What Email Address Would You Like To Use As Your Username For Your Online Application Account?</label>
    <input type="email" name="emailAddress" required>

    <button type="button" onclick="previousSection()">Previous</button>
    <button type="button" onclick="nextSection()">Next</button>
</form>

<script>
    function previousSection() {
        window.location.href = "demo.php"; // Replace "index.php" with the file for the previous section
    }

    function nextSection() {
        // You can add logic to validate inputs if needed
        window.location.href = "sec3.php"; // Replace "section3.php" with the file for the next section
    }
</script>

</body>
</html>
