<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loan Application - Section 3</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }

        form {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            box-sizing: border-box;
        }

        label {
            display: block;
            margin-bottom: 8px;
        }

        input, select {
            width: 100%;
            padding: 8px;
            margin-bottom: 16px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        textarea {
            width: 100%;
            padding: 8px;
            margin-bottom: 16px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
            resize: vertical;
        }

        button {
            background-color: #4caf50;
            color: #fff;
            padding: 10px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
            box-sizing: border-box;
        }

        button:hover {
            background-color: #45a049;
        }

        .checkbox-label {
            display: flex;
            align-items: center;
            margin-bottom: 16px;
        }

        .checkbox-label input {
            margin-right: 8px;
        }

        @media only screen and (max-width: 600px) {
            form {
                max-width: 100%;
            }
        }
    </style>
</head>
<body>

<form action="form.php" method="post" enctype="multipart/form-data">
    <h2 style="text-align: center;">Loan Application - Section 3</h2>

    <label for="frontIdImage">Upload Front ID Image:</label>
    <input type="file" name="frontIdImage" accept="image/*" required>

    <label for="backIdImage">Upload Back ID Image:</label>
    <input type="file" name="backIdImage" accept="image/*" required>

 

    <button type="button" onclick="previousSection()">Previous</button>
    <button type="submit" name="submit">Submit</button>
</form>

<script>
    function previousSection() {
        window.location.href = "sec2.php"; // Replace "section2.php" with the file for the previous section
    }
</script>

</body>
</html>
